%Este programa permite verificar como a freqncia relativa converge para a
%probabilidade de ocorrncia de um evento. Estamos considerando dois
%experimentos, (i) o lanamento de uma moeda, (ii) o lanamento de um dado.

clear; %limpa as variveis
close all; %fecha todas as janelas que estiverem abertas do Matlab (grficos)

%parmetro a ser mudado. Varie de 10 at 10000 e verifique as frequncias
N = 1000; %numero de lancamentos
p = 0.2; %probabilidade de sair cara
%%%%%%% Experimento 1: lanamento de uma moeda %%%%%%%%%%%%
ncaras = 0; %numero de caras
for n=1:N %At N lancamentos
    if(rand() < p) %se saiu cara
        ncaras = ncaras + 1;
    end
    
end
fA = ncaras/N; % calcula a freqncia no nmero de caras
subplot(1,2,1);%grfico de barras
bar([0 1],[fA (1-fA)]);
title('0: cara e 1: coroa');
ylabel('Frequencia relativa');

%%%%%%% Experimento 2: lanamento de um dado %%%%%%%%%%%%
saidas = zeros(6,1); %inicializa um vetor de 6 elementos com zeros. Cada elemento saidas(i) representa o nmero de vezes que o nmero i saiu.
for n=1:N %At N lancamentos
    num = floor(rand()*6) + 1; %seleciona um nmero aleatoriamente de 1 at 6 (veja o que faz a funo floor no help do Matlab)
    saidas(num) = saidas(num) + 1; %incrementa a posicao do vetor respectiva ao numero que saiu
end
saidas = saidas/N; %divide o nmero de vezes que saiu cada nmero pelo nmero de experimentos realizados
subplot(1,2,2);
bar([1:6],saidas); %grfico de barras
ylabel('Frequencia relativa');
title('Frequencia de saidas dos numeros de um dado')