clear;
close all;
clc;

Y = []; %vetor com os valores aleatorios
N = 1000; %quantidade de valores gerados
lambda = 1/10;

for i=1:N
    u = rand();
    x = -log(1-u)/lambda;
    Y = [Y x];
end

[f,x]=hist(Y,100);
bar(x,f);
grid on;


% %comparacao com o valor teorico
% hold on;
% f = [];
% for k=0:0.1:max(Y)
%     f = [f; k lambda*exp(-lambda*k)]
% end
% plot(f(:,1),f(:,2),'-*r');
% legend('Valores aleatorios','Valores exatos');


%comparacao com a funcao do Matlab
Z = exprnd(1/lambda, N, 1);
figure;
[f,x]=hist(Z,100);
bar(x,f);
grid on;
title('Dados gerados com a funcaoo exprnd');
