clear;
close all;
clc;

Y = []; %vetor com os valores aleatorios
N = 1000; %quantidade de valores gerados
lambda = 5;

for i=1:N
    X = 0;
    p = 1;
    while (p >= exp(-lambda))
        u = rand();
        p = u*p;
        if(p >= exp(-lambda))
            X = X + 1;
        end
    end
    Y = [Y X];
end
X = sort(unique(Y));
[f,x]=hist(Y,X);
bar(x,f/sum(f));
grid on;

%comparacao com a funcao do Matlab
hold on;
f = [];
for k=0:max(Y)
    f =[f; k exp(-lambda)*(lambda^k)/factorial(k)];
end
plot(f(:,1),f(:,2),'-*r');
legend('Valores aleatorios','Valores exatos');

