clear;
close all;
clc;

%BOX MULLER METHOD
X = []; %vetor com os valores aleatorios
N = 1000; %quantidade de valores gerados
mu = 10;
sigma = 5;

for i=1:N
    u1 = rand();
    u2 = rand();
    x = sqrt(-2*log(u1))*cos(2*pi*u2);
    y = sqrt(-2*log(u1))*sin(2*pi*u2);
    x = sigma.*x + mu;
    y = sigma.*y + mu;
    X = [X x y];
end
[f,x]=hist(X,100);
%bar(x,f/trapz(x,f));
bar(x,f);
grid on;


%comparacao com a funcao do Matlab
Z = sigma.*randn(2*N,1) + mu;
figure;
[f,x]=hist(Z,100);
bar(x,f);
grid on;
title('Dados gerados com a funcao randn');


% %valores te?ricos
% hold on;
% x = -10:0.1:100;
% g = (1/(sigma*sqrt(2*pi)))*exp(-((x-mu).^2)/(2*sigma^2));
% plot(x,g,'-r');
% 

% %comparacao com o valor teorico
% hold on;
% f = [];
% for k=0:0.1:max(Y)
%     f = [f; k lambda*exp(-lambda*k)]
% end
% plot(f(:,1),f(:,2),'-*r');
% legend('Valores aleatorios','Valores exatos');

