clear;
close all;
clc;

Y = []; %vetor com os valores aleatorios
N = 1000; %quantidade de valores gerados
p = 0.4; %probabilidade de sucesso
n = 100; %numero de experimentos

for i=1:N
    k = 0;
    for j=1:n
        x = 0;
        if(p > rand())
            x=1;
        end
        k = k + x;
    end
    Y = [Y k];
end
X = sort(unique(Y));
[f,x]=hist(Y,X);
bar(x,f/sum(f));
grid on;

%comparacao com o valor teorico
hold on;
f = [];
for k=0:n
    C = factorial(n)/(factorial(n-k)*factorial(k));
    f =[f; k C*(p^k)*(1-p)^(n-k)];
end
plot(f(:,1),f(:,2),'-*r');
legend('Valores aleatorios','Valores exatos');

